$(window).on("load", () => {
  $(".se-pre-con").fadeOut("slow");
});
//begin contact form validation
$("#contact-form").on("submit", (e) => {
  e.preventDefault();
  validateContact();
});
function validateContactInputs(name, email, subject, message, recaptcha) {
  var re =
    /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
  if (name.length < 2) {
    returnedValidationText = "Your name should have at least 2 characters";
    return false;
  } else if (!re.test(email)) {
    returnedValidationText = "Invalid email address";
    return false;
  } else if (subject.length < 2) {
    returnedValidationText = "Your subject should have at least 2 characters";
    return false;
  } else if (message.length < 2) {
    returnedValidationText = "Your message should have at least 2 characters";
    return false;
  } else if (recaptcha == "") {
    returnedValidationText = "Please check the reCaptcha";
    return false;
  } else {
    return true;
  }
}
function validateContact() {
  $(".loader").fadeIn("slow");
  var name = $("#name").val();
  var email = $("#email").val();
  var subject = $("#subject").val();
  var message = $("#message").val();
  var recaptcha = $("#g-recaptcha-response").val();

  if (validateContactInputs(name, email, subject, message, recaptcha)) {
    $.post(
      "send_mail.php",
      {
        name: name,
        email: email,
        subject: subject,
        message: message,
        recaptcha: recaptcha
      },
      function (data) {
        if (data.trim() != "Message Sent Successfully!") {
          Swal.fire({
            showConfirmButton: false,
            title: data,
            text: "",
            icon: "error",
            button: false,
            timer: 2000
          });
          $(".loader").fadeOut("slow");
        } else {
          Swal.fire({
            showConfirmButton: false,
            title: data,
            text: "",
            icon: "success",
            button: false,
            timer: 2000
          });
          $("#name").val("");
          $("#email").val("");
          $("#subject").val("");
          $("#message").val("");
          $(".loader").fadeOut("slow"); //for fading out the loader
        }
      }
    );
  } else {
    Swal.fire({
      showConfirmButton: false,
      title: returnedValidationText,
      text: "",
      icon: "error",
      button: false,
      timer: 2000
    });
    $(".loader").fadeOut("slow");
  }
  return false;
}
//end contact form validation

//Team modal start
const teamDetailsArray = [
  {
    id: "jackson",
    name: "Jackson Nduati",
    photo: "jackson.jpg",
    details:
      "Jackson Nduati is the managing partner at GNK & Associates LLP. He is an Advocate of the High Court of Kenya, a Commissioner for Oaths and Notary Public and heads the corporate, commercial and real estate division in the firm. He is well versed in property and conveyancing, project financing and management, investments and private equity, banking and securities law practice.<br/><br/> Jackson has handled a wide array of legal matters for both local and international clients on project management, business set up, compliance, restructuring, immigration, investments and corporate governance. He has also advised a number of start up companies on venture capital and angel funding, convertible notes and SAFEs. To that end he has been instrumental during their seed and series funding<br/><br/>Jackson is currently serving on the advisory board of Keton Group, a corporate group in the bio-medicine field with presence in the East African region.<br/><br/>Jackson is the local legal representative of GEG KE Limited, a fully owned subsidiary of GEG ehf of Iceland, a global leader in geothermal development and technology and has been delivering turn-key modular geothermal power plants in Kenya.",
    qualifications: [
      "LL.B (University of Nairobi)",
      "Post Graduate Diploma in Law (Kenya School of Law)",
      "Currently pursuing Masters at University of Nairobi"
    ],
    practice: [
      "Conveyancing",
      "Commercial Law",
      "Commercial Litigation",
      "Company Law",
      "Intellectual Property Law",
      "Immigration law",
      "Arbitration"
    ]
  },
  {
    id: "daniel",
    name: "Daniel Kurui",
    photo: "daniel.jpg",
    details:
      "Daniel Kurui is a partner at GNK & Associates LLP. He was admitted as an Advocate of the High Court in 2012. He trained and worked at M.K. Chebii & Co. Advocates from 2012 until 2014 when he left for Australia to pursue his Masters degree. He later joined his colleagues in 2016 to form GNK & Associates LLP Advocates. While at M.K. Chebii & Co. Advocates he attained a wide experience in commercial and corporate law, specifically incorporation and start-up, shareholding and management structures, licensing and regulatory procedures, sale and acquisition of businesses. In addition, Kurui has a sound understanding of criminal and civil litigation and has appeared before numerous administrative tribunals. He is also a competent arbiter having acted in several arbitration matters and is well versed with family and adoption matters, judicial review proceedings, probate and administration and general contractual disputes. As a corporate secretary he has gained valuable experience having acted for the various companies he incorporated.",
    qualifications: [
      "LL.B (University of Nairobi)",
      "Post Graduate Diploma in Law (Kenya School of Law)",
      "Master of Commercial and Resources Law (University of Western Australia)",
      "Certified Public Secretary and a member of the Institute of Certified Public Secretaries of Kenya"
    ],
    practice: [
      "Commercial Law",
      "Conveyancing",
      "Criminal Law",
      "Corporate Governance",
      "Alternative Dispute Resolution",
      "International Oil and Gas Law Mining Law"
    ]
  },
  {
    id: "george",
    name: "George Gaya",
    photo: "george.jpg",
    details:
      "George Gaya is a partner at GNK & Associates LLP. He was admitted as an Advocate of the High Court in 2012. He trained and worked at L.G. Menezes Advocates and later Mulondo, Oundo, Muriuki & Company Advocates until joining his colleagues to form GNK & Associates LLP Advocates. George Gaya has extensive experience in Litigation. George Gaya engages in prosecuting and defending companies and individuals on a range of claims including, construction contracts, industrial accidents, road traffic accidents, material damage, debt recovery and employment and labor-related claims. He has worked on a range of cases concerning contracts, negligence, and breach of trust, breach of confidence and defamation.",
    qualifications: [
      "LL.B (University of Nairobi)",
      "Post Graduate Diploma in Law (Kenya School of Law)"
    ],
    practice: [
      "Civil Litigation",
      "Commercial Litigation",
      "Family Law and Succession",
      "Insurance Law",
      "Judicial Reviewssion",
      "Insurance Law",
      "Judicial Review"
    ]
  }
];
const showTeamModal = (memberIndex) => {
  let memberDetails = teamDetailsArray[memberIndex];
  let qualificationsString = "";
  let practiceString = "";
  $("#member-photo").html(
    '<img class="img-responsive" src="assets/images/' +
      memberDetails.photo +
      '"/>'
  );
  $("#member-name").html(memberDetails.name);
  $("#member-details").html(memberDetails.details);
  memberDetails.qualifications.map(
    (qualification) =>
      (qualificationsString += "<li>" + qualification + "</li>")
  );
  $("#qualifications").html(qualificationsString);

  memberDetails.practice.map(
    (practice) => (practiceString += "<li>" + practice + "</li>")
  );
  $("#practice").html(practiceString);

  $("#team-modal").modal();
};
// Team modal End
